/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class YumiCollections {
    private YumiCollections() {
        throw new UnsupportedOperationException("YumiCollections only contains static definitions.");
    }

    @SafeVarargs
    @NotNull
    public static <T> List<T> concat(@NotNull List<? extends T> first, @NotNull List<? extends T> second, List<? extends T> ... more) {
        ArrayList<Object> list = new ArrayList<Object>(first.size() + second.size() + Arrays.stream(more).mapToInt(Collection::size).sum());
        list.addAll(first);
        list.addAll(second);
        for (List<? extends T> other : more) {
            list.addAll(other);
        }
        return list;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> concat(@NotNull Set<? extends T> first, @NotNull Set<? extends T> second, Set<? extends T> ... more) {
        HashSet<Object> set = new HashSet<Object>(first.size() + second.size() + Arrays.stream(more).mapToInt(Collection::size).sum());
        set.addAll(first);
        set.addAll(second);
        for (Set<? extends T> other : more) {
            set.addAll(other);
        }
        return set;
    }

    public static <T> void forAllPermutations(@NotNull List<T> collection, @NotNull Consumer<List<T>> action) {
        YumiCollections.forAllPermutations(new ArrayList(), collection, action);
    }

    public static <T> void forAllPermutations(@NotNull List<T> selected, @NotNull List<T> toSelect, @NotNull Consumer<List<T>> action) {
        if (toSelect.isEmpty()) {
            action.accept(selected);
        } else {
            for (int i = 0; i < toSelect.size(); ++i) {
                selected.add(toSelect.get(i));
                ArrayList<T> remaining = new ArrayList<T>(toSelect);
                remaining.remove(i);
                YumiCollections.forAllPermutations(selected, remaining, action);
                selected.remove(selected.size() - 1);
            }
        }
    }
}

